(
	-- UV Generator 

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"c8fadbd2-8c3b-4e56-b731-46dbc37b31c7"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			if (mtl.coordType == 2) do 
			(
				append res #("uvw",      undefined, "uvw_"       + (mtl.mapChannel as String))
				append res #("utangent", undefined, "u_tangent_" + (mtl.mapChannel as String))
				append res #("vtangent", undefined, "v_tangent_" + (mtl.mapChannel as String))
			)
			if (mtl.coordType == 3) do 
			(
				append res #("uvw",      undefined, "uvw_0" )
				append res #("utangent", undefined, "u_tangent_0")
				append res #("vtangent", undefined, "v_tangent_0")
			)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			local UVTransform = transMatrix mtl.offset

			UVTransform *= rotateXmatrix mtl.angle.x
			UVTransform *= rotateYmatrix mtl.angle.y
			UVTransform *= rotateZmatrix mtl.angle.z
			UVTransform *= scaleMatrix mtl.Tiling

			append res #("UVTransform", UVTransform)
			append res #("TangentTransform", orthogonalize(copy UVTransform))

			append res #("blur",      mtl.blur) 
			append res #("blurOffs",  mtl.Blur_Offset) 

			append res #("source",    mtl.coordType) 
	
 			res
		)
	)

	AMGData()
)